model:setName( "LowKey_2" )
model:caption( "LowKey II" )

model:addSource("inputImage")
model:addSource("originalImage")
model:addSource("histogram0")
model:addSource("histogram1")
model:addSource("histogram2")
model:addSource("histogram3")
model:addSource("histogram4")
model:addSource("histogram5")

--basis filter added
f1= model:addFilter("LscAndSinterFilter")
f2= model:addFilter("LowKey")

f4= model:addFilter("LevelsAndCurvesFilter")
f3= model:addFilter("LevelsAndCurvesFilter")

------------------------------Kurve---------------------------------
curve_s_fine = [[<Lac_serialization>
<key name="lowNodeX" value="0"/>
<key name="lowNodeY" value="0"/>
<key name="highNodeX" value="1"/>
<key name="highNodeY" value="1"/>
<key name="gamma" value="0"/>
<key name="intNodeCount" value="2"/>
<key name="intNodeX0" value="0.92"/>
<key name="intNodeY0" value="0.98"/>
<key name="intNodeX1" value="0.07"/>
<key name="intNodeY1" value="0.03"/>
<key name="intNodeX2" value="0"/><key name="intNodeY2" value="0"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/><key name="intNodeY4" value="0"/><key name="intNodeX5" value="0"/><key name="intNodeY5" value="0"/><key name="intNodeX6" value="0"/><key name="intNodeY6" value="0"/><key name="intNodeX7" value="0"/><key name="intNodeY7" value="0"/><key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>]]

curve_neutral = [[<Lac_serialization>
<key name="lowNodeX" value="0"/>
<key name="lowNodeY" value="0"/>
<key name="highNodeX" value="1"/>
<key name="highNodeY" value="1"/>
<key name="gamma" value="0"/>
<key name="intNodeCount" value="0"/>
<key name="intNodeX0" value="0"/><key name="intNodeY0" value="0"/><key name="intNodeX1" value="0"/><key name="intNodeY1" value="0"/><key name="intNodeX2" value="0"/><key name="intNodeY2" value="0"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/><key name="intNodeY4" value="0"/><key name="intNodeX5" value="0"/><key name="intNodeY5" value="0"/><key name="intNodeX6" value="0"/><key name="intNodeY6" value="0"/><key name="intNodeX7" value="0"/><key name="intNodeY7" value="0"/><key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>]]

curve_whites = [[ <Lac_serialization>
	<key name="lowNodeX" value="0"/>
	<key name="lowNodeY" value="0"/>
	<key name="highNodeX" value="1"/>
	<key name="highNodeY" value="1"/>
	<key name="gamma" value="0"/>
	<key name="intNodeCount" value="3"/>
	<key name="intNodeX0" value="0.777778"/>
	<key name="intNodeY0" value="0.938889"/>
	<key name="intNodeX1" value="0.533333"/>
	<key name="intNodeY1" value="0.655556"/>
	<key name="intNodeX2" value="0.188889"/>
	<key name="intNodeY2" value="0.194444"/>
	<key name="intNodeX3" value="0"/>
	<key name="intNodeY3" value="0"/>
	<key name="intNodeX4" value="0"/>
	<key name="intNodeY4" value="0"/>
	<key name="intNodeX5" value="0"/>
	<key name="intNodeY5" value="0"/>
	<key name="intNodeX6" value="0"/>
	<key name="intNodeY6" value="0"/>
	<key name="intNodeX7" value="0"/>
	<key name="intNodeY7" value="0"/>
	<key name="intNodeX8" value="0"/>
	<key name="intNodeY8" value="0"/>
	<key name="intNodeX9" value="0"/>
	<key name="intNodeY9" value="0"/>
</Lac_serialization>
 ]]



--lscDefaults--------------------------------------
lsc = model:getFilter(f1)
lsc:setIntParameter( "sinterStrucLscMode0_", 0  )
lsc:setIntParameter( "sinterStrucLscMode1_" ,0 )
lsc:setIntParameter( "tileSizeLevel0", 1 )
lsc:setIntParameter( "tileSizeLevel1",3 )
lsc:setIntParameter( "selectedChannel0_", 0 )
lsc:setIntParameter( "selectedChannel1_", 0 )
lsc:setFloatParameter( "sigma20", 30 )
lsc:setFloatParameter( "sigma21", 30 )
lsc:setIntParameter("lemmingType0", 2)
lsc:setIntParameter( "lemmingType1",2 )
lsc:setFloatParameter("maxDeriv0", 7)
lsc:setFloatParameter( "maxDeriv1", 7 )
lsc:setFloatParameter( "strength0", 25 )
lsc:setFloatParameter( "strength1", 25 )
lsc:setFloatParameter( "strengthFactor", 100 )
lsc:setFloatParameter( "totalStrength", 100 )
lsc:setFloatParameter( "brightness", 0)
lsc:setFloatParameter( "contrast", 0 )
lsc:setFloatParameter( "saturation", -48)
lsc:setFloatParameter( "csStrength", 1.0 )
lsc:setFloatParameter( "deltaT", 30 )
lsc:setFloatParameter( "numberOfTimesteps", 4)
lsc:setFloatParameter( "modifier_A", 0.75)
lsc:setFloatParameter( "modifier_B", 48)
lsc:setFloatParameter( "modifier_C",3)
lsc:setFloatParameter( "modifier_D", 75)

lowkey = model:getFilter(f2)
lowkey:setFloatParameter( "saturation", 0)

model:forwardFloatParameter("glow", f2, "glow", 0.5, 0.0, 1.0, "Glow", "" ) 
--model:forwardFloatParameter("saturation", f2, "saturation", 0.5, 0.0, 1.0, "Saturation", "" ) 
--model:forwardParameter("saturation_lsc", f1, "saturation", "Saturation", "" ) 
model:forwardFloatParameter("strength_gl", f2, "strength", 0.3, 0.0, 1.0, "Standard Low Key", "" )
--original default in CEP3 was 0.33
function combo_lsc(v)
  lsc:setFloatParameter( "strength0", v*60)
  lsc:setFloatParameter( "strength1", v*60)
end
model:addFloatSlider("combo_lsc", 0,0,1.0,"combo_lsc", "Dynamic Low Key", "")

function splitsaturation(v)
  lsc:setFloatParameter( "saturation", v*80-70)
  --lowkey = model:getFilter(f2)
  --lowkey:setFloatParameter( "saturation", v*3 - 1.0)
  -- dieser slider verteilt die User-Saettigung teilweise auf die Lowkey-Saettigung und teilweise auf die Main-Filter-saettigung
end
model:addFloatSlider("saturation", 0.7,0.0,1.0,"splitsaturation", "Saturation", "")

 
 -- Curve "whites"
 
lac = model:getFilter(f4)
lac:setFloatParameter( "strength", 0 )
model:forwardFloatParameter( "strength_wh", f4, "strength", 10, 0, 50, "Whites", "")

lac:setLacData( "lacdataRGB", curve_whites )
lac:setLacData( "lacdataR", curve_neutral )
lac:setLacData( "lacdataG", curve_neutral )
lac:setLacData( "lacdataB", curve_neutral )
lac:setLacData( "lacdataSmartBrightness", curve_whites )

 -- S-Curve

lac = model:getFilter(f3)
lac:setFloatParameter( "strength", 100 )
model:forwardFloatParameter( "contrast", f3, "strength", 100, 0, 100, "Contrast", "")

lac:setLacData( "lacdataRGB", curve_s_fine )
lac:setLacData( "lacdataR", curve_neutral )
lac:setLacData( "lacdataG", curve_neutral )
lac:setLacData( "lacdataB", curve_neutral )
lac:setLacData( "lacdataSmartBrightness", curve_neutral )


 -- Protect Hi/Sh
function protect_shadows_function(v)
  lsc = model:getFilter(f1)
  lsc:setFloatParameter( "protectShadows", v*100)
  lsc:setFloatParameter( "boostShadows", (v*100)/2)
end 
model:addFloatSlider("protect_shadows", 0,0,1,"protect_shadows_function", "Shadows", "")

function protect_hilights_function(v)
  lsc = model:getFilter(f1)
  lsc:setFloatParameter( "protectHighlights", v*100)
  lsc:setFloatParameter( "boostHighlights", (v*100)/2)
end
model:addFloatSlider("protect_hilights", 0,0,1,"protect_hilights_function", "Highlights", "")
